﻿namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// 新しいウェーブサウンドファイルのファイルIDを作成します。
    /// </summary>
    internal class WaveSound2FileIDFactory : FileIDFactory<WaveSound>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public WaveSound2FileIDFactory()
        {
        }

        /// <summary>
        /// コンポーネントのファイルIDを作成します。
        /// </summary>
        /// <param name="component">コンポーネントを指定します。</param>
        /// <returns>ファイルIDを返します。</returns>
        protected override FileID CreateInternal(WaveSound component)
        {
            Assertion.Argument.NotNull(component);
            return new FileID(string.Format(
                "{1}{0}awsd",
                FileID.Separator,
                component.Name
                ));
        }
    }
}
