﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    public class FileIDAggregateFactory : KeyedObjectAggregateFactory<string, Component, FileID>, IFileIDAggregateFactory
    {
        public FileIDAggregateFactory(string basePath, bool isWaveSound2Eanbled = false)
        {
            this.Initialize(basePath, isWaveSound2Eanbled);
        }

        IFileID IFileIDAggregateFactory.Create(string key, Component component)
        {
            return Create(key, component);
        }

        private void Initialize(string basePath, bool isWaveSound2BinaryEnabled)
        {
            Ensure.Argument.NotNull(basePath);

            this.Factories.Add(typeof(StreamSound).Name, new StreamSoundFileIDFactory(basePath));
            this.Factories.Add(typeof(StreamSound).Name + ".Prefetch", new StreamSoundPrefetchFileIDFactory(basePath));
            this.Factories.Add(typeof(WaveSoundSetBase).Name, new FileIDByNameFactory<WaveSoundSetBase>());

            if (isWaveSound2BinaryEnabled)
            {
                this.Factories.Add(typeof(WaveSound).Name, new WaveSound2FileIDFactory());
            }
            else
            {
                this.Factories.Add(typeof(WaveSound).Name, new WaveFileIDFactory<WaveSoundBase>(basePath, component => component.GetTargetSampleRate(), component => component.GetTargetChannelCount()));
            }

            this.Factories.Add(typeof(SequenceSound).Name, new FileIDFactory<SequenceSoundBase>(basePath));
            this.Factories.Add(typeof(SoundSetBank).Name, new FileIDByNameFactory<SoundSetBankBase>());
            this.Factories.Add(typeof(WaveArchiveBase).Name, new FileIDByNameFactory<WaveArchiveBase>());
            this.Factories.Add(typeof(GroupBase).Name, new FileIDByNameFactory<GroupBase>());
            this.Factories.Add(typeof(VelocityRegion).Name, new WaveFileIDFactory<VelocityRegion>(basePath, component => component.GetTargetSampleRate(), component => component.GetTargetChannelCount()));
            this.Factories.Add(typeof(WaveSoundClipConvertModel).Name, new WaveFileIDFactory<WaveSoundClipConvertModel>(basePath, component => component.GetTargetSampleRate(), component => component.GetTargetChannelCount()));
        }
    }
}
