﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    /// <summary>
    /// バンクバイナリ構築用のコンテキスト情報を格納します。
    /// </summary>
    public class BankContext : ComponentContext
    {
        public BankContext(BankConversionTraits traits, string wavePreprocessExePath)
            : base(traits)
        {
            this.WavePreprocessExePath = wavePreprocessExePath;
        }

        public new BankConversionTraits Traits
        {
            get { return base.Traits as BankConversionTraits; }
        }

        /// <summary>
        /// 波形プリプロセス exe ファイルのパスを取得します。
        /// </summary>
        public string WavePreprocessExePath { get; private set; }
    }
}
