﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Projects;

    internal class ParameterValidatorSelector : ComponentSetupSelector
    {
        public ParameterValidatorSelector()
        {
            this.AddSetup(typeof(StreamSound), new StreamSoundParameterValidator());
            this.AddSetup(typeof(WaveSound), new WaveSoundParameterValidator());
            this.AddSetup(typeof(SequenceSound), new SequenceSoundParameterValidator());
            this.AddSetup(typeof(SoundSetBank), new SoundSetBankParameterValidator());
            this.AddSetup(typeof(VelocityRegion), new VelocityRegionParameterValidator());
            this.AddSetup(typeof(WaveSoundClipConvertModel), new WaveSoundClipConvertModelParameterValidator());
        }
    }
}
