﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using ToolDevelopmentKit;

    internal class OutputItemFactorySelector : ComponentSetupSelector
    {
        public OutputItemFactorySelector(FileManager fileManager)
        {
            Ensure.Argument.NotNull(fileManager);

            this.AddSetup(typeof(StreamSound), new StreamSoundOutputFactory(fileManager));
            this.AddSetup(typeof(WaveSoundSetBase), new WaveSoundOutputFactory(fileManager));
            this.AddSetup(typeof(WaveSound), new WaveOutputFactory<ComponentContext, WaveSoundBase>(fileManager, component => component.GetTargetSampleRate()));
            this.AddSetup(typeof(SequenceSound), new SequenceSoundOutputFactory(fileManager));
            this.AddSetup(typeof(WaveArchiveBase), new WaveArchiveOutputFactory(fileManager));
            this.AddSetup(typeof(SoundSetBank), new SoundSetBankOutputFactory(fileManager));
            this.AddSetup(typeof(GroupBase), new GroupOutputFactory(fileManager));
            this.AddSetup(typeof(VelocityRegion), new WaveOutputFactory<ComponentContext, VelocityRegion>(fileManager, component => component.GetTargetSampleRate()));
            this.AddSetup(typeof(WaveSoundClipConvertModel), new WaveOutputFactory<ComponentContext, WaveSoundClipConvertModel>(fileManager, component => component.GetTargetSampleRate()));
        }
    }
}
