﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using Projects;
    using ToolDevelopmentKit;

    internal class SequenceSoundProcessorLinker : ComponentSetup<SoundArchiveContext, SequenceSoundBase>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, SequenceSoundBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            IOutput output = component.GetOutputTarget();

            IConversionProcessor smfProcessor = null;
            if (context.ContainsProcessor(output, SequenceSoundProcessorFactory.OutputID_Intermediate))
            {
                smfProcessor = context.GetProcessor(
                    output, SequenceSoundProcessorFactory.OutputID_Intermediate);
            }

            IConversionProcessor processor = context.GetProcessor(output, string.Empty);

            // SmfProcessor に依存します。
            if (smfProcessor != null)
            {
                processor.Dependencies.Add(smfProcessor);
            }

            // SoundSetBankProcessor に依存します。
            foreach (IConversionProcessor soundSetBankProcessor in
                this.GetSoundSetBankProcessors(context, component))
            {
                if (smfProcessor != null)
                {
                    smfProcessor.Dependencies.Add(soundSetBankProcessor);
                }

                processor.Dependencies.Add(soundSetBankProcessor);
            }
        }

        private IEnumerable<IConversionProcessor> GetSoundSetBankProcessors(
            SoundArchiveContext context, SequenceSoundBase sequenceSound)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(sequenceSound);

            // SEQ は、すべてのバンクをコンバート後に処理する
            // <BTS:nw3_snd:3258> の対処で、バンクコンバート時に出力される .xinl を .xseq が参照する可能性があるめ。
            foreach (SoundSetBankBase soundSetBank in context.SoundSetBanks)
            {
                // メインサウンドアーカイブのバンクを追加サウンドアーカイブで参照する場合はバンク情報のみを出力するので、スキップする
                if (context.IsExternalSoundArchiveBank(soundSetBank))
                {
                    continue;
                }

                IOutput output = soundSetBank.GetOutputTarget();

                foreach (IConversionProcessor processor in context.GetProcessors(output))
                {
                    yield return processor;
                }
            }
        }
    }
}
