﻿// ========================================================================
// <copyright file="WaveSoundParameterValidator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Projects;

    internal class WaveSoundClipConvertModelParameterValidator :
        ParameterValidator<WaveSoundClipConvertModel>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected override void RunInternal(ConversionContext context, WaveSoundClipConvertModel component)
        {
            Component[] componentStack = new Component[] { component };
            this.ValidateFilePath(context, component, componentStack);
        }
    }
}
