﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Linq;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Resources;
    using NintendoWare.SoundFoundation.Logs;

    internal sealed class StreamSoundParameterValidator :
        ParameterValidator<StreamSoundBase>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected override void RunInternal(ConversionContext context, StreamSoundBase component)
        {
            var tracks = component.Children.
                Where<Component>(item => item.IsEnabled).
                Cast<StreamSoundTrackBase>().
                ToArray();

            if (tracks.Length == 0)
            {
                context.Logger.AddLine(
                    new ErrorLine(SoundFoundation.Resources.MessageResource.Message_StreamSoundHasNoTrack, component));
                return;
            }

            Component[] componentStack = new Component[] { component };

            foreach (StreamSoundTrackBase track in tracks)
            {
                this.ValidateFilePath(context, track, componentStack);
            }
        }
    }
}
