﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.IO;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Resources;
    using NintendoWare.ToolDevelopmentKit;

    internal abstract class ParameterValidator<TComponent> :
        ComponentSetup<ConversionContext, TComponent>
        where TComponent : Component
    {
        private const int MaxPath = 256;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンポーネントのファイルパスを検証します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        /// <param name="currentComponentStack">現在のコンポーネントスタックを指定します。</param>
        protected void ValidateFilePath(
            ConversionContext context,
            Component component,
            Component[] currentComponentStack)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);
            Assertion.Argument.NotNull(currentComponentStack);

            if (!component.Parameters.ContainsKey(ProjectParameterNames.FilePath))
            {
                return;
            }

            string filePath = component.GetFilePathForConvert();
            if (filePath.Length == 0)
            {
                context.Logger.AddLine(
                    new Logs.ErrorLine(
                        MessageResource.Message_InvalidFilePath,
                        currentComponentStack));
            }
            else if (
                filePath.Length >= MaxPath - 1 ||
                Path.GetFileName(filePath).Length >= context.Traits.MaxFileName - 1)
            {
                context.Logger.AddLine(
                    new Logs.ErrorLine(
                        string.Format(MessageResource.Message_FilePathTooLong, filePath),
                        currentComponentStack));
            }
        }
    }
}
