﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Logs;
    using Projects;
    using ToolDevelopmentKit;

    internal class SoundNameResolver<TComponent> : NameResolver<TComponent>
        where TComponent : Sound
    {
        public SoundNameResolver(ComponentDictionary componentDictionary)
            : base(componentDictionary)
        {
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="componentDictionary">コンポーネントディクショナリを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected override void RunInternal(
            SoundArchiveContext context, ComponentDictionary componentDictionary, TComponent component)
        {
            PlayerBase player = componentDictionary.Contains(component.PlayerReference) ?
                componentDictionary[component.PlayerReference][0] as PlayerBase : null;

            if (player == null || !player.IsConvertTarget())
            {
                context.Logger.AddLine(
                    new ErrorLine(
                        string.Format(Resources.MessageResource.Message_PlayerNotFound, component.PlayerReference),
                        component)
                    );
                return;
            }

            // 追加サウンドアーカイブのプレイヤーを参照している場合はエラーにする
            if (context.AddonSoundSet != null)
            {
                if (context.Project.IsItemInAddonSoundArchive(player))
                {
                    context.Logger.AddLine(
                        new ErrorLine(
                            string.Format(Resources.MessageResource.Message_PlayerNotFoundInSoundArchive, player.Name),
                            component)
                        );
                    return;
                }
            }

            // プレイヤーを参照していることを示します。
            player.SetIsUsed(true);
        }
    }
}
