﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Core;
    using Projects;
    using ToolDevelopmentKit;

    internal abstract class NameResolver<TComponent> : ComponentSetup<SoundArchiveContext, TComponent>
        where TComponent : Component
    {
        private ComponentDictionary componentDictionary;

        public NameResolver(ComponentDictionary componentDictionary)
        {
            Ensure.Argument.NotNull(componentDictionary);
            this.componentDictionary = componentDictionary;
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, TComponent component)
        {
            RunInternal(context, this.componentDictionary, component);
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="componentDictionary">コンポーネントディクショナリを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected abstract void RunInternal(
            SoundArchiveContext context, ComponentDictionary componentDictionary, TComponent component);
    }
}
