﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.Linq;
    using Projects;
    using ToolDevelopmentKit;

    internal class WaveSoundGarbageOutputCollector : ComponentSetup<SoundArchiveContext, WaveSoundSetBase>
    {
        private FileManager fileManager;

        public WaveSoundGarbageOutputCollector(FileManager fileManager)
        {
            Ensure.Argument.NotNull(fileManager);
            this.fileManager = fileManager;
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, WaveSoundSetBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            if (context.Traits.IsWaveSound2BinaryEnabled)
            {
                // WSD ごとに出力する場合
                foreach (var waveSound in component.Children.Cast<WaveSound>().Where(waveSound => waveSound.IsConvertTarget()))
                {
                    Ensure.Operation.True(waveSound.IsWaveSound2BinaryRequired(), "WaveSound must has WaveSoundResource.");

                    IOutput outputTarget = this.fileManager.GetOutput(waveSound);
                    HashSet<string> usingKeys = new HashSet<string>();

                    foreach (WaveSound sourceWaveSound in
                        context.GetFile(outputTarget).Components.OfType<WaveSound>())
                    {
                        foreach (KeyValuePair<string, WaveArchiveBase> item in sourceWaveSound.GetWaveArchiveDictionary())
                        {
                            usingKeys.Add(item.Key);
                        }
                    }

                    // 入力 .depend ファイルが不要な出力アイテムを保持していた場合は、ここで削除します。
                    foreach (string key in outputTarget.ItemDictionary.Keys.ToArray())
                    {
                        if (usingKeys.Contains(key))
                        {
                            continue;
                        }

                        outputTarget.ItemDictionary[key].Clean();
                        outputTarget.ItemDictionary.Remove(key);
                    }
                }
            }
            else
            {
                // WSDSET で１つ出力する場合
                IOutput outputTarget = this.fileManager.GetOutput(component);
                HashSet<string> usingKeys = new HashSet<string>();

                foreach (WaveSoundSetBase sourceWaveSoundSet in
                    context.GetFile(outputTarget).Components.OfType<WaveSoundSetBase>())
                {
                    foreach (KeyValuePair<string, WaveArchiveBase> item in sourceWaveSoundSet.GetWaveArchiveDictionary())
                    {
                        usingKeys.Add(item.Key);
                    }
                }

                // 入力 .depend ファイルが不要な出力アイテムを保持していた場合は、ここで削除します。
                foreach (string key in outputTarget.ItemDictionary.Keys.ToArray())
                {
                    if (usingKeys.Contains(key))
                    {
                        continue;
                    }

                    outputTarget.ItemDictionary[key].Clean();
                    outputTarget.ItemDictionary.Remove(key);
                }
            }
        }
    }
}
