﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using Projects;
    using ToolDevelopmentKit;

    internal class ComponentSetupSelector
    {
        private readonly Dictionary<Type, IComponentSetup> setups = new Dictionary<Type, IComponentSetup>();

        public void AddSetup(Type targetType, IComponentSetup setup)
        {
            Ensure.Argument.NotNull(targetType);
            Ensure.Argument.NotNull(setup);
            this.setups.Add(targetType, setup);
        }

        public void Run(ConversionContext context, Component component)
        {
            Ensure.Argument.NotNull(context);
            Ensure.Argument.NotNull(component);

            Type type = component.GetType();
            if (!this.setups.ContainsKey(type)) { return; }

            this.setups[type].Run(context, component);
        }
    }
}
