﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.IO;
    using Logs;
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// Smfファイルのコンバート機能を提供します。
    /// </summary>
    public class SmfConverter : ConsoleBasedConverter<ConversionContext>, ISmfConverter
    {
        public SmfConverter(string converterExePath)
        {
            Ensure.Argument.NotNull(converterExePath);
            Ensure.Argument.StringNotEmpty(converterExePath);

            this.ConverterExePath = converterExePath;
            this.Timeout = TimeSpan.FromMinutes(3);
        }

        public string ConverterExePath { get; private set; }

        public string InputPath { get; set; }

        public string OutputPath { get; set; }

        public int TimeBase { get; set; }

        public Component[] TargetComponents { get; set; }

        protected override void InitializeProcess(ConversionContext context, System.Diagnostics.Process process)
        {
            base.InitializeProcess(context, process);

            Directory.CreateDirectory(Path.GetDirectoryName(this.OutputPath));
        }

        protected override string GetFileName(ConversionContext context)
        {
            return this.ConverterExePath;
        }

        protected override string GetArguments(ConversionContext context)
        {
            if (this.InputPath == null || this.InputPath.Length == 0)
            {
                throw new Exception("internal error : invalid input path.");
            }

            if (this.OutputPath == null || this.OutputPath.Length == 0)
            {
                throw new Exception("internal error : invalid output path.");
            }

            if (this.TimeBase == 0)
            {
                return string.Format("\"{0}\" -o \"{1}\" --timebase 48", this.InputPath, this.OutputPath);
            }
            else
            {
                return string.Format("\"{0}\" -o \"{1}\" --timebase {2}",
                        this.InputPath, this.OutputPath, this.TimeBase);
            }
        }

        protected override InformationLine CreateInformationLine(string message)
        {
            return new InformationLine(message, this.TargetComponents);
        }

        protected override ErrorLine CreateErrorLine(string message)
        {
            return new ErrorLine(message, this.TargetComponents);
        }
    }
}
