﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.IO;
    using Core.IO;
    using Logs;
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// シーケンスサウンドテキストファイルのコンバート機能を提供します。
    /// </summary>
    public class SequenceSoundTextConverter : ConsoleBasedConverter<ConversionContext>, ISequenceSoundTextConverter
    {
        public SequenceSoundTextConverter(string converterExePath)
        {
            Ensure.Argument.NotNull(converterExePath);
            Ensure.Argument.StringNotEmpty(converterExePath);

            this.ConverterExePath = converterExePath;
            this.Timeout = TimeSpan.FromMinutes(3);
        }

        public string ConverterExePath { get; private set; }

        public string InputPath { get; set; }

        public string OutputPath { get; set; }

        public Component[] TargetComponents { get; set; }

        public new bool Run(ConversionContext context)
        {
            return base.Run(context);
        }

        protected override void InitializeProcess(ConversionContext context, System.Diagnostics.Process process)
        {
            base.InitializeProcess(context, process);

            Directory.CreateDirectory(Path.GetDirectoryName(this.OutputPath));
        }

        protected override string GetFileName(ConversionContext context)
        {
            return this.ConverterExePath;
        }

        protected override string GetArguments(ConversionContext context)
        {
            if (this.InputPath == null || this.InputPath.Length == 0)
            {
                throw new Exception("internal error : invalid input path.");
            }

            if (this.OutputPath == null || this.OutputPath.Length == 0)
            {
                throw new Exception("internal error : invalid output path.");
            }

            string projectFileDirectory = PathEx.MakeRelative
                (Path.GetDirectoryName(context.ProjectFilePath),
                 Path.GetDirectoryName(this.ConverterExePath)).Replace('/', '\\');
            return string.Format("\"{0}\" -o \"{1}\" --include-dir \"{2}\"",
                                 this.InputPath,
                                 this.OutputPath,
                                 projectFileDirectory);
        }

        protected override InformationLine CreateInformationLine(string message)
        {
            return new InformationLine(message, this.TargetComponents);
        }

        protected override ErrorLine CreateErrorLine(string message)
        {
            return new ErrorLine(message);
        }
    }
}
