﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Logs;
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// サウンドプロジェクトをコンバートし、サウンドアーカイブバイナリを生成します。
    /// NintendoSDK 向けの変更が適用されたインターフェイスで NW4F との互換はありません。
    /// </summary>
    public interface ISoundProjectConverter2
    {
        event EventHandler<OutputLineEventArgs> LineOutput;

        event EventHandler<CustomConversionEventArgs> PostConvert;

        //-----------------------------------------------------------------

        SoundProjectConversionTraits Traits { get; }

        SoundProjectConversionSettings Settings { get; }

        bool IsSucceeded { get; }

        bool IsFailed { get; }

        bool IsCanceled { get; }

        int ProgressMax { get; }

        int ProgressCurrent { get; }

        //-----------------------------------------------------------------

        void Prepare(SoundProjectService projectService);
        void Cleanup();

        void Run(IEnumerable<BankService> bankServices);

        void Run(
            IEnumerable<BankService> bankServices,
            Func<string, bool> isCacheUse);

        void Run(
            IEnumerable<BankService> bankServices,
            Func<string, bool> isCacheUse,
            bool isForced);

        void Run(
            SoundSet addonSoundSet,
            IEnumerable<BankService> bankServices,
            Func<string, bool> isCacheUse,
            bool isForced);

        void RunParts(
            IEnumerable<BankService> bankServices,
            IEnumerable<SoundSetItem> soundSetItems,
            string outputDirectoryPath,
            bool doGarbageCorrection);

        bool ExecutePreConvertCommands();
        bool ExecutePostConvertCommands(IEnumerable<string> outputFilePaths);

        void Cancel();

        void Wait();
    }
}
