﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// エンコーディングを管理します。
    /// </summary>
    public static class Encoding
    {
        public const string Pcm = "PCM";
        public const string DspAdpcm = "DSPADPCM";
        public const string ImaAdpcm = "IMAADPCM";
        public const string PcmStream = "PCM-STREAM";
        public const string DspAdpcmStream = "DSPADPCM-STREAM";

        /// <summary>
        /// エンコーディングテキストをWaveCodeのエンコーディングに変換します。
        /// </summary>
        /// <param name="text">エンコーディングテキストを指定します。</param>
        /// <param name="format">フォーマットを指定します。</param>
        /// <returns>WaveCodecのエンコーディングを返します。</returns>
        public static WaveCodecEncoding ToWaveCodecEncoding(this string text, WaveFormat format)
        {
            Ensure.Argument.NotNull(format);

            switch (text)
            {
                case Pcm:
                    switch (format.BitsPerSample)
                    {
                        case 8:
                            return WaveCodecEncoding.PCM8;

                        case 16:
                            return format.IsLittleEndian ?
                                WaveCodecEncoding.PCM16_LE : WaveCodecEncoding.PCM16_BE;
                    }
                    break;

                case DspAdpcm:
                    return WaveCodecEncoding.DSP_ADPCM;

                case ImaAdpcm:
                    return WaveCodecEncoding.IMA_ADPCM;
            }

            throw new Exception("invalid wave format.");
        }
    }
}
