﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Commands;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    /// <summary>
    /// KeyStroke の拡張機能を提供します。
    /// </summary>
    public static class KeyStrokeEx
    {
        /// <summary>
        /// KeyStroke[] から テキストを取得します。
        /// </summary>
        /// <param name="keys">KeyStroke[]。</param>
        /// <returns>テキスト。</returns>
        public static string ToShortcutKeyText(this KeyStroke[] keys)
        {
            string keysText = string.Empty;

            foreach (KeyStroke key in keys)
            {

                if (0 < keysText.Length)
                {
                    keysText += ", ";
                }

                keysText += key.ToShortcutKeyText();

            }

            return keysText;
        }

        /// <summary>
        /// KeyStroke から テキストを取得します。
        /// </summary>
        /// <param name="keys">KeyStroke。</param>
        /// <returns>テキスト。</returns>
        public static string ToShortcutKeyText(this KeyStroke key)
        {
            if (null == key) { throw new ArgumentNullException("key"); }
            return key.ToKeys().ToShortcutKeyText();
        }

        /// <summary>
        /// KeyStroke から Keys へ変換します。
        /// </summary>
        /// <param name="key">変換元の KeyStroke。</param>
        /// <returns>変換後の Keys。</returns>
        public static Keys ToKeys(this KeyStroke keyStroke)
        {
            if (null == keyStroke) { throw new ArgumentNullException("keyStroke"); }
            return (Keys)(keyStroke.Modifiers | keyStroke.Key);
        }
    }
}
