﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using NintendoWare.SoundFoundation.Projects;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public interface ISampleMapItemsSource
    {
        IKeyRegionCollection Items { get; }
        event EventHandler Updated;

        IKeyRegion CreateKeyRegion(int index, int minimum, int maximum, string filePath);
        void DivideKeyRegion(IKeyRegion target);
        void DivideVelocityRegion(IVelocityRegion target);
        void CopyKeyRegion(IKeyRegion iKeyRegion0, IKeyRegion iKeyRegion1);
        void CopyKeyRegion(IKeyRegion iKeyRegion0, int keyMin, int keyMax);
        void CopyVelocityRegion(IVelocityRegion iVelRegion0, IVelocityRegion iVelRegion1);
        void CopyVelocityRegion(IVelocityRegion iVelRegion0, int keyMin, int keyMax);
        void SwapKeyRegion(IKeyRegion iKeyRegion0, IKeyRegion iKeyRegion1);
        void SwapVelocityRegion(IVelocityRegion iVelRegion0, IVelocityRegion iVelRegion1);
        void ChangeKeyRegionValue(IKeyRegion iKeyRegion, int min, int max);
        void RemoveAndCreateVelocityRegion(IVelocityRegion iVelRegion, int keyMin, int keyMax);

        void BeginTransaction();
        void EndTransaction();
        void CancelTransaction();
    }

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public interface IRegion
    {
        Component Target { get; }
        int MinimumIntact { set; }
        int MaximumIntact { set; }
        int Minimum { get; set; }
        int Maximum { get; set; }
    }
}
