﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Diagnostics;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ParameterListItemCollection : Collection<IListItem>, IListItemCollection
    {
        public event NotifyCollectionChangedEventHandler CollectionChanged;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>

        IEnumerator<IListItem> IEnumerable<IListItem>.GetEnumerator()
        {
            return this.GetEnumerator();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new int Count
        {
            get { return base.Count; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new IListItem this[int index]
        {
            get { return base[index]; }
            set { base[index] = value; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new int IndexOf(IListItem item)
        {
            return base.IndexOf(item);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new bool Contains(IListItem item)
        {
            return base.Contains(item);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new void CopyTo(IListItem[] array, int index)
        {
            base.CopyTo(array, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ParameterListItem[] ToArray()
        {
            List<ParameterListItem> list = new List<ParameterListItem>();
            foreach (ParameterListItem item in this)
            {
                list.Add(item as ParameterListItem);
            }
            return list.ToArray();
        }

        /// <summary>
        ///
        /// </summary>
        void IListItemCollection.Move(int index, IListItem item)
        {
            // 対応しません。
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void InsertItem(int index, IListItem item)
        {
            base.InsertItem(index, item);
            OnCollectionChanged(CreateEventArgsAdd(item, IndexOf(item)));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void RemoveItem(int index)
        {
            IListItem item = this[index];

            base.RemoveItem(index);
            OnCollectionChanged(CreateEventArgsRemove(item, index));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void ClearItems()
        {
            base.ClearItems();
            OnCollectionChanged(CreateEventArgsReset());
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsReset()
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Reset);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsAdd(IListItem item, int index)
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Add, item, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsRemove(IListItem item, int index)
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Remove, item, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected void OnCollectionChanged(NotifyCollectionChangedEventArgs e)
        {
            if (CollectionChanged != null)
            {
                CollectionChanged(this, e);
            }
        }
    }
}
