﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.Core.Parameters;
using NintendoWare.SoundFoundation.Projects;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ParameterListItem : IListItem, IDisposable
    {
        //private static Random random = new Random();    //テスト

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ParameterListItem(IParameterProvider provider)
        {
            Target = provider;
            Length = 16;
            //Length += random.Next( 0, 3) * 8;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        void IDisposable.Dispose()
        {
            Target = null;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public virtual IParameterProvider Target
        {
            get; set;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ParameterListAdapter Adapter { get; set; }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool Enabled { get; set; }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool Visible { get; set; }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public int Length { get; set; }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public virtual bool CanEdit
        {
            get { return true; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public virtual IParameterValue GetValue(string name)
        {
            ComponentReference reference = Target as ComponentReference;

            if (reference == null)
            {
                return null;
            }

            return CreateParameterEditor(name, new TextParameterValue(reference.TargetName));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public virtual IConstParameterValue GetConstValue(string name)
        {
            ComponentReference reference = Target as ComponentReference;

            if (reference == null)
            {
                return null;
            }

            return new TextParameterValue(reference.TargetName);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected IParameterValue CreateParameterEditor(string name, IParameterValue value)
        {
            return CreateParameterEditor(name, value, OnValueChanged);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected IParameterValue CreateParameterEditor(string name, IParameterValue value, ParameterEventHandler handler)
        {
            ParameterEditor parameterEditor = null;

            parameterEditor = new ParameterEditor(name, value);
            parameterEditor.ValueChanged += handler;

            return parameterEditor;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected virtual IParameterProvider GetTarget(string name)
        {
            return Target;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValueChanged(object sender, EventArgs e)
        {
            ParameterEditor parameterEditor = sender as ParameterEditor;
            string name = parameterEditor.Name;

            Adapter.SetValue(GetTarget(name), name, parameterEditor.Value);
        }
    }
}
