﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    #region ** イベントハンドラ

    /// <summary>
    /// 値変更イベントハンドラ
    /// </summary>
    public delegate void ValueChangedEventHandler(object sender, ValueChangedEventArgs e);

    /// <summary>
    /// 値変更イベントパラメータ
    /// </summary>
    public class ValueChangedEventArgs
    {
        private bool _commited = true;		// 値の変更が確定したかどうかを示します。
        private bool _synchronized = false;		// 同期による値変更かどうかを示します。

        public ValueChangedEventArgs(bool commited, bool synchronized)
        {
            _commited = commited;
            _synchronized = synchronized;
        }

        #region ** プロパティ

        /// <summary>
        /// 値の変更が確定したかどうかを示します。
        /// </summary>
        public bool Commited
        {
            get { return _commited; }
        }

        /// <summary>
        /// 同期による値変更かどうかを示します。
        /// </summary>
        public bool Synchronized
        {
            get { return _synchronized; }
        }

        #endregion
    }

    #endregion
}
