﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ComponentHeaderItemCollection : Collection<IHeaderItem>, IHeaderItemCollection
    {
        public event NotifyCollectionChangedEventHandler CollectionChanged;

        public ComponentHeaderItemCollection()
        {
        }

        public void AddRange(IEnumerable<IHeaderItem> collection)
        {
            if (collection.Count() > 0)
            {
                int index = this.Count;

                foreach (IHeaderItem item in collection)
                {
                    this.Add(item);
                }
                NotifyCollectionChangedEventArgs eventArgs;
                eventArgs = new NotifyCollectionChangedEventArgs
                    (NotifyCollectionChangedAction.Add, collection, index);
                OnCollectionChanged(eventArgs);
            }
        }

        //

        IEnumerator<IHeaderItem>
        IEnumerable<IHeaderItem>.GetEnumerator()
        {
            return this.GetEnumerator();
        }

        public new void CopyTo(IHeaderItem[] array, int arrayIndex)
        {
            base.CopyTo(array, arrayIndex);
        }

        public new bool Contains(IHeaderItem item)
        {
            return base.Contains((ComponentHeaderItem)item);
        }

        public new IHeaderItem this[int i]
        {
            get
            {
                return base[i];
            }
            set
            {
                base[i] = (ComponentHeaderItem)value;
            }
        }

        public new int IndexOf(IHeaderItem item)
        {
            return base.IndexOf((ComponentHeaderItem)item);
        }

        //

        protected override void ClearItems()
        {
            base.ClearItems();
            NotifyCollectionChangedEventArgs eventArgs =
                new NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction.Reset);
            OnCollectionChanged(eventArgs);
        }

        protected override void InsertItem(int index, IHeaderItem item)
        {
            if (item != null)
            {
                ((ComponentHeaderItem)item).TypeChanged += new EventHandler(this.ItemTypeSort);
                base.InsertItem(index, item);
                NotifyCollectionChangedEventArgs eventArgs;
                eventArgs = new NotifyCollectionChangedEventArgs
                    (NotifyCollectionChangedAction.Add, item, index);
                OnCollectionChanged(eventArgs);
            }
        }

        protected override void RemoveItem(int index)
        {
            IHeaderItem item = this[index];
            base.RemoveItem(index);
            NotifyCollectionChangedEventArgs eventArgs;
            eventArgs = new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Remove, item, index);
            OnCollectionChanged(eventArgs);
        }

        protected void OnCollectionChanged(NotifyCollectionChangedEventArgs e)
        {
            if (CollectionChanged != null)
            {
                CollectionChanged(this, e);
            }
        }

        private void ItemTypeSort(object sender, EventArgs e)
        {
            List<IHeaderItem> freeItems = new List<IHeaderItem>();
            List<IHeaderItem> leftItems = new List<IHeaderItem>();
            List<IHeaderItem> rightItems = new List<IHeaderItem>();

            foreach (IHeaderItem item in this)
            {
                switch (item.Type)
                {
                    case HeaderItemType.Free:
                        freeItems.Add(item);
                        break;

                    case HeaderItemType.LeftFixed:
                        leftItems.Add(item);
                        break;

                    case HeaderItemType.RightFixed:
                        rightItems.Add(item);
                        break;
                }
            }

            foreach (IHeaderItem item in freeItems)
            {
                leftItems.Add(item);
            }
            foreach (IHeaderItem item in rightItems)
            {
                leftItems.Add(item);
            }

            base.Clear();
            foreach (IHeaderItem item in leftItems.ToArray())
            {
                this.Add(item);
            }

            NotifyCollectionChangedEventArgs eventArgs =
                new NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction.Reset);
            OnCollectionChanged(eventArgs);
        }
    }
}
