﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ComponentHeaderItem : IHeaderItem
    {
        private string _Name = string.Empty;
        private HeaderItemType _Type = HeaderItemType.Free;
        private int _Length;

        public ComponentHeaderItem(string name)
        {
            _Name = name;
            Length = 100;
            Visible = true;
            Type = HeaderItemType.Free;
            Alignment = HorizontalAlignment.Center;
            MaximumLength = 10000;
            MinimumLength = 5;
            SortOrders =
                new List<SortOrder>() { SortOrder.Ascending, SortOrder.Descending, SortOrder.None };
        }

        public string Name
        {
            get
            {
                return _Name;
            }
        }

        public string Text
        {
            get; set;
        }

        public int Length
        {
            get
            {
                return _Length;
            }
            set
            {
                _Length = value;

                if (_Length < MinimumLength)
                {
                    _Length = MinimumLength;
                }
                else if (MaximumLength < _Length)
                {
                    _Length = MaximumLength;
                }
            }
        }

        public bool Visible
        {
            get; set;
        }

        public HeaderItemType Type
        {
            get
            {
                return _Type;
            }
            set
            {
                if (_Type != value)
                {
                    _Type = value;
                    OnTypeChanged(EventArgs.Empty);
                }
            }
        }

        public HorizontalAlignment Alignment
        {
            get; set;
        }

        public int MaximumLength
        {
            get; set;
        }

        public int MinimumLength
        {
            get; set;
        }

        public List<SortOrder> SortOrders
        {
            get; set;
        }

        public event EventHandler TypeChanged;
        private void OnTypeChanged(EventArgs e)
        {
            if (TypeChanged != null)
            {
                TypeChanged(this, e);
            }
        }
    }
}
