﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Windows.Forms;
using Win32 = NintendoWare.SoundFoundation.Core.Win32;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class NMenuStrip : MenuStrip
    {
        private NMenuStripMouseActivateMode mouseActivateMode = NMenuStripMouseActivateMode.NoActivate;

        /// <summary>
        /// マウスでアクティブにされたときに発生します。
        /// </summary>
        public event CancelEventHandler MouseActivate;

        /// <summary>
        /// マウスでアクティブにされた場合の動作を取得または設定します。
        /// </summary>
        [DefaultValue(NMenuStripMouseActivateMode.NoActivate)]
        public NMenuStripMouseActivateMode MouseActivateMode
        {
            get { return this.mouseActivateMode; }
            set { this.mouseActivateMode = value; }
        }

        protected virtual void OnMouseActivate(CancelEventArgs e)
        {
            if (null != MouseActivate)
            {
                MouseActivate(this, e);
            }
        }

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case Win32.WM.WM_MOUSEACTIVATE:

                    base.WndProc(ref m);

                    CancelEventArgs e = new CancelEventArgs();
                    OnMouseActivate(e);

                    if (!e.Cancel)
                    {
                        // 既定では戻り値が MA_ACTIVATEANDEAT となり、
                        // 以降のマウス処理がされないので、ここで上書きする
                        switch (this.mouseActivateMode)
                        {
                            case NMenuStripMouseActivateMode.Activate:
                                m.Result = (IntPtr)Win32.MA.MA_ACTIVATE;
                                break;

                            case NMenuStripMouseActivateMode.ActivateAndIgnoreEvent:
                                m.Result = (IntPtr)Win32.MA.MA_ACTIVATEANDEAT;
                                break;

                            case NMenuStripMouseActivateMode.NoActivate:
                                m.Result = (IntPtr)Win32.MA.MA_NOACTIVATE;
                                break;

                            case NMenuStripMouseActivateMode.NoActivateAndIgnoreEvent:
                                m.Result = (IntPtr)Win32.MA.MA_NOACTIVATEANDEAT;
                                break;
                        }
                    }

                    return;
            }

            base.WndProc(ref m);
        }
    }

    public enum NMenuStripMouseActivateMode
    {
        Activate,
        ActivateAndIgnoreEvent,
        NoActivate,
        NoActivateAndIgnoreEvent,
    }
}
