﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms.Windowless
{
    #region ** 通常スタイル

    public class NWTabControlStyleTop : NWControlStyle
    {
        public NWTabControlStyleTop()
        {
            Add(typeof(NWControlHost),
                    new NWControlHostTemplateFactory(NWTabControl.NWTabControlHostTemplate.CreateInstance));
            Add(typeof(NWTabControl),
                    new NWControlTemplateFactory(NWTabControl.NWTabControlTemplateTop.CreateInstance));
            Add(typeof(NWTabControl.NWTabPanel),
                    new NWControlTemplateFactory(NWTabControl.NWTabPanelTemplateTop.CreateInstance));
            Add(typeof(NWTabControl.NWTab),
                    new NWControlTemplateFactory(NWTabControl.NWTabTemplateTop.CreateInstance));
        }
    }

    public class NWTabControlStyleBottom : NWControlStyle
    {
        public NWTabControlStyleBottom()
        {
            Add(typeof(NWControlHost),
                    new NWControlHostTemplateFactory(NWTabControl.NWTabControlHostTemplate.CreateInstance));
            Add(typeof(NWTabControl),
                    new NWControlTemplateFactory(NWTabControl.NWTabControlTemplateBottom.CreateInstance));
            Add(typeof(NWTabControl.NWTabPanel),
                    new NWControlTemplateFactory(NWTabControl.NWTabPanelTemplateBottom.CreateInstance));
            Add(typeof(NWTabControl.NWTab),
                    new NWControlTemplateFactory(NWTabControl.NWTabTemplateBottom.CreateInstance));
        }
    }

    public class NWTabControlStyleLeft : NWControlStyle
    {
        public NWTabControlStyleLeft()
        {
            Add(typeof(NWControlHost),
                    new NWControlHostTemplateFactory(NWTabControl.NWTabControlHostTemplate.CreateInstance));
            Add(typeof(NWTabControl),
                    new NWControlTemplateFactory(NWTabControl.NWTabControlTemplateLeft.CreateInstance));
            Add(typeof(NWTabControl.NWTabPanel),
                    new NWControlTemplateFactory(NWTabControl.NWTabPanelTemplateLeft.CreateInstance));
            Add(typeof(NWTabControl.NWTab),
                    new NWControlTemplateFactory(NWTabControl.NWTabTemplateLeft.CreateInstance));
        }
    }

    public class NWTabControlStyleRight : NWControlStyle
    {
        public NWTabControlStyleRight()
        {
            Add(typeof(NWControlHost),
                    new NWControlHostTemplateFactory(NWTabControl.NWTabControlHostTemplate.CreateInstance));
            Add(typeof(NWTabControl),
                    new NWControlTemplateFactory(NWTabControl.NWTabControlTemplateRight.CreateInstance));
            Add(typeof(NWTabControl.NWTabPanel),
                    new NWControlTemplateFactory(NWTabControl.NWTabPanelTemplateRight.CreateInstance));
            Add(typeof(NWTabControl.NWTab),
                    new NWControlTemplateFactory(NWTabControl.NWTabTemplateRight.CreateInstance));
        }
    }

    #endregion
}
