﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;

using NintendoWare.SoundFoundation.Commands;

namespace NintendoWare.SoundFoundation.Windows.CommandBars
{
    /// <summary>
    /// コマンドバーアイテムの情報を管理します。
    /// </summary>
    public abstract class CommandBarItem
    {
        private string _uri = null;
        private int _width = 0;
        private object _tag = null;
        private bool _enable = true;
        private bool _visible = true;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="uri">アイテムURI。</param>
        public CommandBarItem(string uri)
        {
            _uri = (null == uri) ? string.Empty : uri;
        }

        /// <summary>
        /// アイテムのURIを取得します。
        /// </summary>
        public string Uri
        {
            get { return _uri; }
        }

        /// <summary>
        /// ローカライズされたテキストを取得します。
        /// </summary>
        public abstract string Text { get; set; }

        /// <summary>
        /// アイテムの幅を取得または設定します。
        /// </summary>
        public int Width
        {
            get { return _width; }
            set { _width = value; }
        }

        /// <summary>
        /// アイテムの有効状態を取得または設定します。
        /// </summary>
        public bool Enable
        {
            get { return _enable; }
            set { _enable = value; }
        }

        /// <summary>
        /// アイテムの表示状態を取得または設定します。
        /// </summary>
        public bool Visible
        {
            get { return _visible; }
            set { _visible = value; }
        }

        /// <summary>
        /// アイテムのタグを取得または設定します。
        /// </summary>
        public object Tag
        {
            get { return _tag; }
            set { _tag = value; }
        }

        public virtual IEnumerable<CommandBarItem> FindItems(string uri)
        {
            yield break;
        }
    }
}
