﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// サウンド中間出力の特性を管理します。
    /// </summary>
    public class SoundIntermediateOutputTraits
    {
        private string soundProjectDocumentTypeName = string.Empty;
        private string soundSetDocumentTypeName = string.Empty;
        private string bankDocumentTypeName = string.Empty;

        private string soundProjectFile = "xspj";
        private string soundSetFile = "xsst";
        private string bankFile = "xbnk";

        private string textSequeneSoundFile = "xseq";
        private string bankIncludeFile = "xinl";
        private string soundIDCppHeaderFile = "xsid";

        //-----------------------------------------------------------------
        //ドキュメントの種類
        //-----------------------------------------------------------------

        /// <summary>
        /// プロジェクトドキュメントの種類を取得します。
        /// </summary>
        public string SoundProjectDocumentTypeName
        {
            get { return this.soundProjectDocumentTypeName; }
            set
            {
                this.Validate(value);
                this.soundProjectDocumentTypeName = value;
            }
        }

        /// <summary>
        /// サウンドセットドキュメントの種類を取得します。
        /// </summary>
        public string SoundSetDocumentTypeName
        {
            get { return this.soundSetDocumentTypeName; }
            set
            {
                this.Validate(value);
                this.soundSetDocumentTypeName = value;
            }
        }

        /// <summary>
        /// バンクドキュメントの種類を取得します。
        /// </summary>
        public string BankDocumentTypeName
        {
            get { return this.bankDocumentTypeName; }
            set
            {
                this.Validate(value);
                this.bankDocumentTypeName = value;
            }
        }

        //-----------------------------------------------------------------
        // 中間ファイルの拡張子
        //-----------------------------------------------------------------

        public string SoundProjectFileExtension
        {
            get { return this.soundProjectFile; }
            set
            {
                this.Validate(value);
                this.soundProjectFile = value;
            }
        }

        public string SoundSetFileExtension
        {
            get { return this.soundSetFile; }
            set
            {
                this.Validate(value);
                this.soundSetFile = value;
            }
        }

        public string BankFileExtension
        {
            get { return this.bankFile; }
            set
            {
                this.Validate(value);
                this.bankFile = value;
            }
        }

        public string TextSequenceSoundFileExtension
        {
            get { return this.textSequeneSoundFile; }
            set
            {
                this.Validate(value);
                this.textSequeneSoundFile = value;
            }
        }

        //-----------------------------------------------------------------
        // その他の拡張子
        //-----------------------------------------------------------------

        public string BankIncludeFileExtension
        {
            get { return this.bankIncludeFile; }
            set
            {
                this.Validate(value);
                this.bankIncludeFile = value;
            }
        }

        public string SoundIDCppHeaderFileExtension
        {
            get { return this.soundIDCppHeaderFile; }
            set
            {
                this.Validate(value);
                this.soundIDCppHeaderFile = value;
            }
        }

        //-----------------------------------------------------------------

        private void Validate(string value)
        {
            Ensure.Argument.StringNotEmpty(value);
        }
    }
}
