﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// サウンドバイナリ出力の特性を管理します。
    /// </summary>
    public class SoundBinaryOutputTraits
    {
        private string soundArchiveBinaryFileExtension = "bxsar";
        private string streamSoundBinaryFileExtension = "bxstm";
        private string streamSoundPrefetchBinaryFileExtension = "bxstp";
        private string waveSoundBinaryFileExtension = "bxwsd";
        private string waveSoundBinary2FileExtension = "bawsd";
        private string sequenceSoundBinaryFileExtension = "bxseq";
        private string bankBinaryFileExtension = "bxbnk";
        private string waveBinaryFileExtension = "bxwav";
        private string waveArchiveBinaryFileExtension = "bxwarc";
        private string groupBinaryFileExtension = "bxgrp";

        //-----------------------------------------------------------------
        // バイナリファイルの拡張子
        //-----------------------------------------------------------------

        public string SoundArchiveBinaryFileExtension
        {
            get { return this.soundArchiveBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.soundArchiveBinaryFileExtension = value;
            }
        }

        public string StreamSoundBinaryFileExtension
        {
            get { return this.streamSoundBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.streamSoundBinaryFileExtension = value;
            }
        }

        public string StreamSoundPrefetchBinaryFileExtension
        {
            get { return this.streamSoundPrefetchBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.streamSoundPrefetchBinaryFileExtension = value;
            }
        }

        public string WaveSoundBinaryFileExtension
        {
            get { return this.waveSoundBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.waveSoundBinaryFileExtension = value;
            }
        }

        public string WaveSoundBinary2FileExtension
        {
            get { return this.waveSoundBinary2FileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.waveSoundBinary2FileExtension = value;
            }
        }

        public string SequenceSoundBinaryFileExtension
        {
            get { return this.sequenceSoundBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.sequenceSoundBinaryFileExtension = value;
            }
        }

        public string BankBinaryFileExtension
        {
            get { return this.bankBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.bankBinaryFileExtension = value;
            }
        }

        public string WaveBinaryFileExtension
        {
            get { return this.waveBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.waveBinaryFileExtension = value;
            }
        }

        public string WaveArchiveBinaryFileExtension
        {
            get { return this.waveArchiveBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.waveArchiveBinaryFileExtension = value;
            }
        }

        public string GroupBinaryFileExtension
        {
            get { return this.groupBinaryFileExtension; }
            set
            {
                this.ValidateExtension(value);
                this.groupBinaryFileExtension = value;
            }
        }

        //-----------------------------------------------------------------

        private void ValidateExtension(string value)
        {
            Ensure.Argument.NotNull(value);
            Ensure.Argument.StringNotEmpty(value);
        }
    }
}
