﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using Core;
    using Core.Parameters;
    using Resources;
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using ToolDevelopmentKit;

    /// <summary>
    /// SampleRate 型のパラメータ値を格納します。
    /// </summary>
    public class SampleRateParameterValue : IntParameterValue
    {
        public const int SampleRateUnsettingValue = 0; // 未設定な状態を示します。
        public const int SampleRateMinValue = 2000; // サンプルレート最小値 2kHz
        public const int SampleRateMaxValue = 192000; // サンプルレート最大値 192kHz

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SampleRateParameterValue()
            : base(SampleRateUnsettingValue, SampleRateMinValue, SampleRateMaxValue)
        {
        }

        public SampleRateParameterValue(int sampleRate)
            : base(sampleRate, SampleRateMinValue, SampleRateMaxValue)
        {
        }

        /// <summary>
        /// 未設定な状態かどうかを取得します。
        /// </summary>
        public bool IsUnsettingValue
        {
            get
            {
                return this.Value == SampleRateUnsettingValue;
            }
        }
    }
}
