﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;
    using ToolDevelopmentKit;

    public class EnvelopeParameterValue : ComplexParameterValue<Envelope>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public EnvelopeParameterValue()
            : this(new Envelope())
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public EnvelopeParameterValue(Envelope value)
            : base(value)
        {
            SetParameterAttributes(Envelope.PropertyNameAttack, ParameterAttributes.ComputeHash);
            SetParameterAttributes(Envelope.PropertyNameDecay, ParameterAttributes.ComputeHash);
            SetParameterAttributes(Envelope.PropertyNameHold, ParameterAttributes.ComputeHash);
            SetParameterAttributes(Envelope.PropertyNameSustain, ParameterAttributes.ComputeHash);
            SetParameterAttributes(Envelope.PropertyNameRelease, ParameterAttributes.ComputeHash);
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// エンベロープの Attack を取得または設定します。
        /// </summary>
        public IntParameterValue Attack
        {
            get { return this.Parameters[Envelope.PropertyNameAttack] as IntParameterValue; }
        }

        /// <summary>
        /// エンベロープの Decay を取得または設定します。
        /// </summary>
        public IntParameterValue Decay
        {
            get { return this.Parameters[Envelope.PropertyNameDecay] as IntParameterValue; }
        }

        /// <summary>
        /// エンベロープの Hold を取得または設定します。
        /// </summary>
        public IntParameterValue Hold
        {
            get { return this.Parameters[Envelope.PropertyNameHold] as IntParameterValue; }
        }

        /// <summary>
        /// エンベロープの Sustain を取得または設定します。
        /// </summary>
        public IntParameterValue Sustain
        {
            get { return this.Parameters[Envelope.PropertyNameSustain] as IntParameterValue; }
        }

        /// <summary>
        /// エンベロープの Release を取得または設定します。
        /// </summary>
        public IntParameterValue Release
        {
            get { return this.Parameters[Envelope.PropertyNameRelease] as IntParameterValue; }
        }

        /// <summary>
        /// XML シリアライズ時の要素名を取得します。
        /// </summary>
        protected override string XmlElementName
        {
            get
            {
                return ProjectParameterNames.EnvelopeParams;
            }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// パラメータの値を取得するキャストオペレータです。
        /// </summary>
        /// <param name="value">対象となるパラメータ値を指定します。</param>
        /// <returns>パラメータの値を返します。</returns>
        public static implicit operator Envelope(EnvelopeParameterValue value)
        {
            Ensure.Argument.NotNull(value);
            return value.Value;
        }
    }
}
