﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;
    using Core.Collections;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    public class UserCommand : ICloneable
    {
        private string name = string.Empty;
        private string command = string.Empty;
        private string iconFilePath = string.Empty;

        public UserCommand()
        {
        }

        public static int MaxCount
        {
            get { return 8; }
        }

        public string Name
        {
            get { return this.name; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.name = value;
            }
        }

        public string Command
        {
            get { return this.command; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.command = value;
            }
        }

        public string IconFilePath
        {
            get
            {
                return this.iconFilePath;
            }
            set
            {
                Ensure.Argument.NotNull(value);
                this.iconFilePath = value;
            }
        }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        public UserCommand Clone()
        {
            UserCommand clone = new UserCommand()
            {
                Name = string.Copy(this.Name),
                Command = string.Copy(this.Command),
                IconFilePath = string.Copy(this.IconFilePath)
            };
            return clone;
        }

        /// <summary>
        /// 値を比較します。
        /// </summary>
        public override bool Equals(Object obj)
        {
            if (obj is UserCommand)
            {
                UserCommand other = obj as UserCommand;
                if (this.Name != other.Name ||
                    this.Command != other.Command ||
                    this.IconFilePath != other.IconFilePath)
                {
                    return false;
                }
                return true;
            }
            else
            {
                return false;
            }
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
    }
}
