﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;
    using Core.Collections;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    public class SoundListOutput : ICloneable
    {
        private string name = string.Empty;
        private string title = string.Empty;
        private string filePath = string.Empty;

        public SoundListOutput()
        {
            this.OutputType = SoundListOutputType.EachSoundSet;
            this.IsIgnoreDisableItems = false;
            this.ListOutputs = new SoundListList();
        }

        public string Name
        {
            get { return this.name; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.name = value;
            }
        }

        public string Title
        {
            get { return this.title; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.title = value;
            }
        }

        public string FilePath
        {
            get { return this.filePath; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.filePath = value;
            }
        }

        public SoundListOutputType OutputType { get; set; }

        public bool IsIgnoreDisableItems { get; set; }

        public IKeyedList<string, ListOutput> ListOutputs { get; private set; }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        public SoundListOutput Clone()
        {
            SoundListOutput clone = new SoundListOutput()
            {
                Name = string.Copy(this.Name),
                Title = string.Copy(this.Title),
                FilePath = string.Copy(this.FilePath),
                OutputType = this.OutputType,
                IsIgnoreDisableItems = this.IsIgnoreDisableItems,
            };

            foreach (ListOutput value in this.ListOutputs)
            {
                clone.ListOutputs.Add(value.Clone());
            }

            return clone;
        }

        /// <summary>
        /// 値を比較します。
        /// </summary>
        public override bool Equals(Object obj)
        {
            if (obj is SoundListOutput)
            {
                SoundListOutput other = obj as SoundListOutput;
                if (this.Name != other.Name ||
                    this.Title != other.Title ||
                    this.FilePath != other.FilePath ||
                    this.OutputType != other.OutputType ||
                    this.IsIgnoreDisableItems != other.IsIgnoreDisableItems ||
                    this.ListOutputs.Count != other.ListOutputs.Count)
                {
                    return false;
                }

                for (int i = 0; i < this.ListOutputs.Count; i++)
                {
                    if (this.ListOutputs[i].Equals(other.ListOutputs[i]) == false)
                    {
                        return false;
                    }
                }

                return true;
            }
            else
            {
                return false;
            }
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }

        private class SoundListList : KeyedListDecorator<string, ListOutput>
        {
            public SoundListList()
                : base(new ObservableList<ListOutput>(), GetItemName)
            {
            }

            private static string GetItemName(ListOutput item)
            {
                Ensure.Argument.NotNull(item);
                return item.Name;
            }
        }
    }
}
