﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class WaveEncodingEx
    {
        public static string ToText(this WaveEncoding value)
        {
            switch (value)
            {
                case WaveEncoding.Adpcm:
                    return "Adpcm";

                case WaveEncoding.Pcm16:
                    return "Pcm16";

                case WaveEncoding.Pcm8:
                    return "Pcm8";

                case WaveEncoding.NoConvert:
                    return "NoConvert";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static WaveEncoding Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Adpcm":
                    return WaveEncoding.Adpcm;

                case "Pcm16":
                    return WaveEncoding.Pcm16;

                case "Pcm8":
                    return WaveEncoding.Pcm8;

                case "NoConvert":
                    return WaveEncoding.NoConvert;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
