﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class WaveArchiveLoadTypeEx
    {
        public static string ToText(this WaveArchiveLoadType value)
        {
            switch (value)
            {
                case WaveArchiveLoadType.Individual:
                    return "Individual";

                case WaveArchiveLoadType.Whole:
                    return "Whole";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static WaveArchiveLoadType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Individual":
                    return WaveArchiveLoadType.Individual;

                case "Whole":
                    return WaveArchiveLoadType.Whole;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
