﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    ///
    public static class StructureTypesEx
    {
        public static string ToText(this StructureTypes value)
        {
            switch (value)
            {
                case StructureTypes.Integer:
                    return "Integer";
                case StructureTypes.UInteger:
                    return "UInteger";
                case StructureTypes.Decimal:
                    return "Decimal";
                case StructureTypes.Boolean:
                    return "Boolean";
            }
            Debug.Assert(false, "Invalid type");
            return null;
        }

        public static StructureTypes Parse(string value)
        {
            switch (value)
            {
                case "Integer":
                    return StructureTypes.Integer;
                case "UInteger":
                    return StructureTypes.UInteger;
                case "Decimal":
                    return StructureTypes.Decimal;
                case "Boolean":
                    return StructureTypes.Boolean;
            }
            Debug.Assert(false, "Invalid text");
            return StructureTypes.Integer;
        }
    }
}
