﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------


namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Resources;

    public static class InterpolationTypeEx
    {
        public static string ToText(this InterpolationType value)
        {
            switch (value)
            {
                case InterpolationType.Polyphase:
                    return "Polyphase";

                case InterpolationType.Linear:
                    return "Linear";

                case InterpolationType.None:
                    return "None";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static InterpolationType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Polyphase":
                    return InterpolationType.Polyphase;

                case "Linear":
                    return InterpolationType.Linear;

                case "None":
                    return InterpolationType.None;
            }

            if (MessageResource.Label_InterpolationType_Polyphase == text)
            {
                return InterpolationType.Polyphase;
            }
            if (MessageResource.Label_InterpolationType_Linear == text)
            {
                return InterpolationType.Linear;
            }
            if (MessageResource.Label_InterpolationType_None == text)
            {
                return InterpolationType.None;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
