﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class GroupOutputTypeEx
    {
        public static string ToText(this GroupOutputType value)
        {
            switch (value)
            {
                case GroupOutputType.Embedding:
                    return "Embedding";

                case GroupOutputType.Link:
                    return "Link";

                case GroupOutputType.UserManagement:
                    return "UserManagement";

                case GroupOutputType.None:
                    return "None";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static GroupOutputType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Embedding":
                    return GroupOutputType.Embedding;

                case "Link":
                    return GroupOutputType.Link;

                case "UserManagement":
                    return GroupOutputType.UserManagement;

                case "None":
                    return GroupOutputType.None;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
