﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;

    public static class CaseChangeTypeEx
    {
        public static string ToText(this CaseChangeType value)
        {
            switch (value)
            {
                case CaseChangeType.ToUpper:
                    return "ToUpper";

                case CaseChangeType.ToLower:
                    return "ToLower";

                case CaseChangeType.None:
                    return "None";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static CaseChangeType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "ToUpper":
                    return CaseChangeType.ToUpper;

                case "ToLower":
                    return CaseChangeType.ToLower;

                case "None":
                    return CaseChangeType.None;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
