﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Text;
    using NintendoWare.SoundFoundation.Documents;

    /// HACK: レガシーテキストシーケンスサウンドをインポートするために作成した暫定版です。
    /// <summary>
    /// テキストシーケンスサウンドを含むドキュメントです。
    /// </summary>
    public class TextSequenceSoundDocument : Document
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public TextSequenceSoundDocument()
        {
            this.Text = string.Empty;
        }

        /// <summary>
        /// ドキュメントの種類を取得します。
        /// </summary>
        public override string TypeName
        {
            get { return Platforms.Any.TextSequenceSoundDocument; }
        }

        public bool IsReadOnly
        {
            get { return !this.Resource.CanWrite; }
        }

        /// <summary>
        /// テキストを取得または設定します。
        /// </summary>
        public string Text { get; set; }

        /// <summary>
        /// ドキュメントのクローンを作成します。
        /// </summary>
        public override object Clone()
        {
            throw new NotImplementedException();
        }
    }
}
