﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System.IO;
    using System.Xml.Serialization;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;
    using NintendoWare.ToolDevelopmentKit;

    public class SoundSetDocumentWriter : IDocumentWriter
    {
        public SoundSetDocumentWriter()
        {
            this.DocumentTypeName = Platforms.Any.SoundSetDocument;
            this.DocumentVersion = Platforms.Any.SoundSetDocumentVersion;
            this.Platform = Platforms.Any.PlatformName;
        }

        /// <summary>
        /// 対応するドキュメントの種類を取得します。
        /// </summary>
        public string DocumentTypeName { get; protected set; }

        public string DocumentVersion { get; protected set; }

        public string Platform { get; protected set; }

        public string ProductName { get; set; }

        public string ProductVersion { get; set; }

        public virtual void Write(IStreamResource resource, Document document, Document[] documents)
        {
            Ensure.Argument.True(resource is FileResource);
            Ensure.Argument.True(document is SoundSetDocument);

            // ★ヘッダパラメータは仮
            XmlSoundSetFile file = new XmlSoundSetFile()
            {
                Version = this.DocumentVersion,
                Platform = this.Platform,
                Header = new XmlCommonFileHeader()
                {
                    Title = "TestSoundSet",
                },
            };

            SoundSetModel2XmlTranslator translator = new SoundSetModel2XmlTranslator();
            translator.PathResolver.BasePath =
                Path.GetDirectoryName(resource.Key.GetFullPath());

            file.Body.SoundSet = translator.Run((document as SoundSetDocument).SoundSet);

            using (Stream stream = File.Open(resource.Key, FileMode.Create, FileAccess.Write, FileShare.None))
            {
                new XmlSerializer(typeof(XmlSoundSetFile)).Serialize(stream, file);
            }
        }
    }
}
