﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Projects
{
    /// <summary>
    /// SoundDocument イベントを処理するメソッドを表します。
    /// </summary>
    /// <param name="sender">イベントのソース。</param>
    /// <param name="e">SoundDocument イベントデータ。</param>
    public delegate void SoundDocumentEventHandler(object sender, SoundDocumentEventArgs e);

    /// <summary>
    /// SoundDocument イベントデータを格納します。
    /// </summary>
    public class SoundDocumentEventArgs : EventArgs
    {
        private SoundDocument _document;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="document">SoundDocument。</param>
        public SoundDocumentEventArgs(SoundDocument document)
        {
            _document = document;
        }

        /// <summary>
        /// SoundDocument を取得します。
        /// </summary>
        public SoundDocument Document
        {
            get { return _document; }
        }
    }
}
