﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System.Collections.Generic;
    using System.IO;
    using System.Xml.Serialization;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;
    using NintendoWare.ToolDevelopmentKit;

    public class BankDocumentWriter : IDocumentWriter
    {
        public BankDocumentWriter()
        {
            this.DocumentTypeName = Platforms.Any.BankDocument;
            this.DocumentVersion = Platforms.Any.BankDocumentVersion;
            this.Platform = Platforms.Any.PlatformName;
        }

        /// <summary>
        /// 対応するドキュメントの種類を取得します。
        /// </summary>
        public string DocumentTypeName { get; set; }

        public string DocumentVersion { get; set; }

        public string Platform { get; set; }

        public string ProductName { get; set; }

        public string ProductVersion { get; set; }

        public void Write(IStreamResource resource, Document document, Document[] documents)
        {
            Ensure.Argument.True(resource is FileResource);
            Ensure.Argument.True(document is BankDocument);

            // ★ヘッダパラメータは仮
            XmlBankFile file = new XmlBankFile()
            {
                Version = this.DocumentVersion,
                Platform = this.Platform,
                Header = new XmlCommonFileHeader()
                {
                    Title = "TestBank",
                },
            };

            BankModel2XmlTranslator translator = new BankModel2XmlTranslator();
            translator.PathResolver.BasePath =
                Path.GetDirectoryName(resource.Key.GetFullPath());

            file.Body.Bank = translator.Run((document as BankDocument).Bank);

            using (Stream stream = File.Open(resource.Key, FileMode.Create, FileAccess.Write, FileShare.None))
            {
                new XmlSerializer(typeof(XmlBankFile)).Serialize(stream, file);
            }
        }
    }
}
