﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;

    public class BankDocument : SoundDocument
    {
        private bool isDirtyOtherFactor = false;
        private string documentTypeName = string.Empty;

        private ComponentDictionaryImpl components = null;
        private Bank bank = null;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public BankDocument(string documentTypeName)
        {
            if (null == documentTypeName) { throw new ArgumentNullException("documentTypeName"); }
            if (0 == documentTypeName.Length) { throw new ArgumentException("documentTypeName.Length must not be 0."); }

            this.documentTypeName = documentTypeName;
            this.components = new ComponentDictionaryImpl();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public Bank Bank
        {
            get { return this.bank; }
            set
            {
                this.bank = value;
                this.components.Add(this.bank.Name, this.bank);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string TypeName
        {
            get { return this.documentTypeName; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override object Clone()
        {
            //未実装
            return null;
        }

        /// <summary>
        /// ドキュメントの最上位コンポーネントの一覧を取得します。
        /// </summary>
        public override Component[] TopComponents
        {
            get { return new Component[] { Bank }; }
        }

        /// <summary>
        /// 他の要因でドキュメントが編集の設定、取得します。
        /// </summary>
        public bool Dirty
        {
            get { return isDirtyOtherFactor; }
            set
            {
                if (isDirtyOtherFactor != value)
                {
                    isDirtyOtherFactor = value;
                    OnDirtyChanged(EventArgs.Empty);
                }
            }
        }

        /// <summary>
        /// 他の要因でドキュメントが編集されているかどうかを調べます。
        /// </summary>
        protected override bool IsDirtyOtherFactor
        {
            get { return isDirtyOtherFactor; }
        }
    }
}
