﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using NintendoWare.SoundFoundation.Documents;

    public interface IDocumentImporter
    {
        /// <summary>
        /// インポート元のドキュメントタイプ名を取得します。
        /// </summary>
        string SourceDocumentTypeName { get; }

        /// <summary>
        /// インポート後のドキュメントタイプ名を取得します。
        /// </summary>
        string DestinationDocumentTypeName { get; }

        /// <summary>
        /// ドキュメントをインポートします。
        /// </summary>
        /// <param name="document">インポートするドキュメントを指定します。</param>
        /// <returns>インポートしたドキュメント参照の配列を返します。</returns>
        DocumentReference[] Import(Document document);
    }
}
