﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System.ComponentModel;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ドキュメントのインポートイベントデータを格納します。
    /// </summary>
    public class DocumentImportEventArgs : CancelEventArgs
    {
        private readonly Document[] documents = new Document[0];
        private string logFilePath = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="document">インポート対象のドキュメントを指定します。</param>
        public DocumentImportEventArgs(Document document)
            : this(new Document[] { document })
        {
            Ensure.Argument.NotNull(document);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="documents">インポート対象のドキュメントを指定します。</param>
        public DocumentImportEventArgs(Document[] documents)
        {
            Ensure.Argument.NotNull(documents);
            this.documents = documents;
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="documents">インポート対象のドキュメントを指定します。</param>
        public DocumentImportEventArgs()
        {
        }

        /// <summary>
        /// インポート対象のドキュメントを取得します。
        /// </summary>
        public Document[] Documents
        {
            get { return this.documents; }
        }
    }
}
