﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class KeyRegion : BankItem, ICloneable
    {
        ///
        object ICloneable.Clone()
        {
            KeyRegion keyRegion = new KeyRegion();

            keyRegion.KeyMin = this.KeyMin;
            keyRegion.KeyMax = this.KeyMax;

            foreach (VelocityRegion velRegion in this.Children)
            {
                ICloneable cloner = velRegion as ICloneable;
                Debug.Assert(cloner != null, "Cloner is null");
                VelocityRegion clonedVelRegion = cloner.Clone() as VelocityRegion;
                keyRegion.Children.Add(clonedVelRegion);
            }

            return keyRegion;
        }

        ///--------------------------------
        /// <summary>
        /// 開始位置
        /// </summary>
        public int KeyMin
        {
            get { return GetIntValue(ProjectParameterNames.KeyRegion.KeyMin); }
            set { SetIntValue(ProjectParameterNames.KeyRegion.KeyMin, value); }
        }

        ///--------------------------------
        /// <summary>
        /// 終了位置
        /// </summary>
        public int KeyMax
        {
            get { return GetIntValue(ProjectParameterNames.KeyRegion.KeyMax); }
            set { SetIntValue(ProjectParameterNames.KeyRegion.KeyMax, value); }
        }

        ///--------------------------------
        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            SetInstanceIntValue(ProjectParameterNames.KeyRegion.KeyMin, 0, 0, 127);
            SetInstanceIntValue(ProjectParameterNames.KeyRegion.KeyMax, 0, 0, 127);

            // バンクバイナリ依存パラメータ
            this.SetParameterAttributes(ProjectParameterNames.KeyRegion.KeyMin, ParameterAttributes.ComputeHash);
            this.SetParameterAttributes(ProjectParameterNames.KeyRegion.KeyMin, ParameterAttributes.ComputeHash);
        }
    }
}
