﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundFoundation.Projects
{
    /// <summary>
    /// Component イベントを処理するメソッドを表します。
    /// </summary>
    /// <param name="sender">イベントのソース。</param>
    /// <param name="e">Component イベントデータ。</param>
    public delegate void ComponentEventHandler(object sender, ComponentEventArgs e);

    /// <summary>
    /// Component イベントデータを格納します。
    /// </summary>
    public class ComponentEventArgs : EventArgs
    {
        private Component[] _components;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ComponentEventArgs()
        {
            _components = new Component[0];
        }


        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="component">Component。</param>
        public ComponentEventArgs(Component component)
        {
            if (null == component) { throw new ArgumentNullException("component"); }
            _components = new Component[] { component };
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="components">Component の列挙子。</param>
        public ComponentEventArgs(IEnumerable<Component> components)
        {
            if (null == components) { throw new ArgumentNullException("components"); }
            _components = components.ToArray();
        }

        /// <summary>
        /// コンポーネントの一覧を取得します。
        /// </summary>
        public Component[] Components
        {
            get { return _components; }
        }
    }
}
