﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;

    public delegate void BankServiceEventHandler(object sender, BankServiceEventArgs e);

    /// <summary>
    /// バンクサービスイベントデータを格納します。
    /// </summary>
    public class BankServiceEventArgs : EventArgs
    {
        private BankService _bankService;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="bankService">バンクサービス。</param>
        public BankServiceEventArgs(BankService bankService)
        {
            _bankService = bankService;
        }

        /// <summary>
        /// バンクサービスを取得します。
        /// </summary>
        public BankService BankService
        {
            get { return _bankService; }
        }
    }
}
