﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using Core;
    using ToolDevelopmentKit;

    /// <summary>
    /// コンポーネントを生成します。
    /// </summary>
    /// <typeparam name="TValue">生成するコンポーネントの型を指定します。</typeparam>
    public class ComponentFactoryDelegation<TValue> : ObjectFactoryDelegation<Type, Component>
        where TValue : Component, new()
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="handler">オブジェクトのインスタンス生成ハンドラを指定します。</param>
        public ComponentFactoryDelegation(CreateHandler handler)
            : base(handler)
        {
        }

        /// <summary>
        /// 指定されたパラメータからオブジェクトのインスタンスを作成します。
        /// </summary>
        /// <param name="param">パラメータを指定します。</param>
        /// <returns>生成したオブジェクトのインスタンスを返します。</returns>
        public override Component Create(Type param)
        {
            Ensure.Argument.NotNull(param);
            Ensure.Argument.True(typeof(TValue) == param || typeof(TValue).IsSubclassOf(param));
            return base.Create(param);
        }
    }
}
